!english
.debug 0
% Demonstrate ray intersection snaps. To be run from snaps.rsc - not stand alone
.-1
.=> ANNOT
.create_ray
.fc -185 20
.fc -142 48
.=> RAY2
.finished_rays
.new_text
A ray intersection snap can be used to find the intersection of any two rays.
The intersection point need not lie between the ends of either ray.
When you select a ray intersection snap the cursor changes
to a small box and the words Ray 1.


This is a prompt for you to select the first ray of interest.
.pause
.new_text
The cursor should be positioned so that the box lies either over a
single ray or over two rays.


If a single ray crosses the cursor box then the cursor will change
to display the words Ray 2 and you must hold the control key down
while you select a second ray.


Click on continue and this will be demonstrated to you.
.pause
.annotation Ray 1
.fc 131 10
.fcr -20 20
.annotation Ray 2
.fc 138 4
.fcr 40 20
.annotation Intersection point
.intersect_snap
.move 131 10
.pause 500
.ck 131 10
.new_text
The first ray now shows drag handles because it has been selected.


The cursor has changed to the new form and must be moved to the second
ray and the mouse button clicked while the control key is held down.


Click on continue.
.unselect_annotations
.pause
.move 138 4
.pause 500
.control_key 1
.ck 138 4
.control_key 0
.new_text
Once the second ray is selected the intersection point is found and
the rays are unselected.
.fcr 20 -20
.unselect_all
.pause
.clear_annotations
.new_text
Alternatively you may be able to select both rays in one operation.
.annotation Clicking on two rays at once
.fc 49 100
.fcr 20 20
.unselect_all
.annotation Intersection point
.intersect_snap
.move 49 100
.pause 500
.ck 49 100
.fcr 20 -20
.unselect_all
.move_rel 50 -50
.new_text
If you click on more than two rays then the cursor will remain in the
Ray 1 form and you must try again.


If you forget, or choose not to, hold the control key down when selecting a
second ray then the first selected ray is ignored and you must select another
ray to take its place - the cursor remains in the Ray 2 form.  
.pause
.clear_annotations
.goto RINT1
:RINTLOOP
.painting 0
.unselect_all
.ANNOT
.if== -1 NOANNOT
.select_object ANNOT
.delete
:NOANNOT
.painting 1
:RINT1
.new_text
Click on continue then move the cursor into the main Raytrace window
and try selecting two rays for a ray intersection snap.
.pause
.intersect_snap
.user_click
.if== -1 RINTFAIL
.control_key 0
.no_snap
.unselect_all
.annotation Snaps to this point
.fc lastclick.x lastclick.y
.fcr 10 10
.=> ANNOT
.new_text
Do you want to try this again?
.yes_no RINTLOOP RINTEND
:RINTEND
.unselect_all
.clear_annotations
.select_object RAY2
.delete
.return
:RINTFAIL
.control_key 0
.unselect_all
.new_text
The snap failed. You must have chosen two rays which were parallel.


Click on continue and try again.
.pause
.goto END1
