!english
.debug 0
% Second order rainbow demo
% Intended to follow after rainbow.rsc
.enable_undo 0
.quiet_snap 1
.grid_snap 0
.new_text
Please wait a few moments while the ray diagram is reset.
.file_new
.painting 0
.refractive_index 1.32986 1.33580 1.34009
.create_region
.fast_click 0 0
.arcseg
.chord_tan
.fast_click 0 100
.fast_click 100 0
.fast_click 0 0
.fast_click -100 100
.end_element
.=> DROP
.annotation Water drop
.object_coordinates DROP 2 middle
.mid_snap
.fast_click X Y
.fast_click_rel -50 -50
.red
.create_ray
.fast_click 300 1
.fast_click 150 1
.=> INCIDENT
.annotation Incident ray
.object_coordinates INCIDENT middle
.mid_snap
.fast_click X Y
.fast_click_rel 20 30
.finished_rays
.child_by INCIDENT refraction
.=> FIRSTRFR
.select_object FIRSTRFR
.reflect 1
.refract 0
.unselect_all
.child_by FIRSTRFR reflection
.=> SECOND
.select_object SECOND
.reflect 1
.refract 0
.child_by SECOND reflection refraction
.=> EXITRAY
.select_object EXITRAY
.set_length 150
.unselect_all
.annotation Exiting ray
.object_coordinates EXITRAY middle
.mid_snap
.fast_click X Y
.fast_click_rel 50 60
.unselect_all
.protractor
.select_object INCIDENT EXITRAY
.intersect_snap
.control_key 1
.fast_click 1000 1000
.control_key 0
.object_coordinates EXITRAY end
.end_snap
.fast_click X Y
.object_coordinates INCIDENT start
.end_snap
.fast_click X Y
.=> ANGLE
.select_object ANGLE
.object_coordinates ANGLE lead_to
.fast_click X Y
.fast_click 198 -37
.unselect_all
.show_protractors 1
.painting 1
.new_text
Here you see a ray incident on a water drop as before. Now the ray undergoes two partial
reflections inside the drop and then exits.


In this case, in order to get an exiting ray that heads towards an obsever on the
ground the incident ray must enter the drop below the centre.
.pause
.new_text
.select_object INCIDENT
.object_coordinates INCIDENT middle
.fast_move X Y
.fast_click X Y
.mouse_limits 150 0.5 150 45
Now if you drag the incident ray up and down you should discover that the angle of
deviation between the incident and exiting rays goes through a minimum.
.allow_drag
.click 150 2.5
.new_text
This happens at about 50.1 degrees as shown here for red rays.
.pause
.select_object INCIDENT
.blue
.object_coordinates INCIDENT middle
.fast_move X Y
.fast_click X Y
.mouse_limits 150 0.5 150 45
.new_text
If the incident ray is blue then you will find the minimum deviation angle is larger
than for the red light - about 52.7 degrees
.allow_drag
.click 150 2.6
.new_text
The rest of the explanation for the second order rainbow is similar to that for the
first order rainbow. The blue light that enters the eye appears to come
from higher in the sky than the red light because it is deviated through a greater
angle than the red light.


That's the end of the rainbow scripts.
.pause
.enable_undo 1
.quiet_snap 0
.return
