!english
.debug 0
% This script runs through the formation of a rainbow
.file_new
.enable_undo 0
.quiet_snap 1
.grid_snap 0
.new_text
This script shows how a rainbow is formed by water droplets.


Do you want to proceed?
.yes_no SKIP
.new_text
Please wait a few moments while the script sets up the ray diagram
.painting 0
.refractive_index 1.32986 1.33580 1.34009
.create_region
.fast_click 0 0
.arcseg
.chord_tan
.fast_click 0 100
.fast_click 100 0
.fast_click 0 0
.fast_click -100 100
.end_element
.=> DROP
.annotation Water drop
.object_coordinates DROP 2 middle
.mid_snap
.fast_click X Y
.fast_click_rel -50 -50
.red
.create_ray
.fast_click 300 70
.fast_click 150 70
.=> INCIDENT
.annotation Incident ray
.object_coordinates INCIDENT middle
.mid_snap
.fast_click X Y
.fast_click_rel 20 30
.finished_rays
.child_by INCIDENT refraction
.=> FIRSTRFR
.annotation Partial reflection
.object_coordinates FIRSTRFR end
.end_snap
.fast_click X Y
.fast_click_rel -50 50
.select_object FIRSTRFR
.reflect 1
.refract 0
.child_by FIRSTRFR reflection refraction
.=> EXITRAY
.select_object EXITRAY
.set_length 150
.unselect_all
.annotation Exiting ray
.object_coordinates EXITRAY middle
.mid_snap
.fast_click X Y
.fast_click_rel -50 -20
.unselect_all
.protractor
.select_object INCIDENT EXITRAY
.intersect_snap
.control_key 1
.fast_click 1000 1000
.control_key 0
.object_coordinates EXITRAY start
.end_snap
.fast_click X Y
.end_snap
.fast_click 200 70
.=> ANGLE
.select_object ANGLE
.object_coordinates ANGLE lead_to
.fast_click X Y
.fast_click -170 15
.unselect_all
.show_protractors 0
.painting 1
.new_text
Consider a light ray coming from the sun on the right and striking the water drop as shown.


The ray is refracted and strikes the back face of the drop.


Some of the light striking the back surface will be reflected. This is only a partial
reflection like you see when you look at a sheet of plane glass.
.pause
.new_text
This reflected light then refracts at the front surface of the drop and exits travelling
downwards and towards the right. 
.pause
.show_protractors 1
.new_text
A protractor has been used to indicate the angle the exiting ray makes with the
incident ray.
.pause


As the incident ray strikes the drop at different heights above the drop centre you
can see that the angle between the incident and exiting rays varies.
.pause
.unselect_all
.select_object INCIDENT
.object_coordinates INCIDENT middle
.fast_move X Y
.fast_click X Y
.move 150 99
.pause 300
.move 150 60
.pause 300
.move X Y
.new_text
Move the mouse now to drag the incident ray up and down. You should notice
that at some point the angle between the incident ray and exiting ray passes
through a maximum.
.mouse_limits 150 51 150 99
.allow_drag
.new_text
In case you didn't find it this occurs when the angle is about 42.5 degrees
as shown now.
.click X 93.7


It is this maximum in the angle of deflection that causes the formation of
the rainbow. The role of the maximum will be made clearer later in the script.
.pause
.new_text
Since the refractive index of the water varies slightly with wavelength the
angle of maximum deviation is slightly different for each colour.


Now the ray colour is green try and find the maximum deviation angle by dragging
the incident ray.
.select_object INCIDENT
.green
.fast_move X 93.7
.fast_click X 93.7
.shift_key 1
.mouse_limits 150 50 150 120
.allow_drag
.shift_key 0
.click 150 93.2
.new_text
For green light the maximum angle is slightly less than for the red. About 41.7 degrees
as shown now.


Do you want to find the maximum angle for blue light?
.yes_no DOBLUE NOBLUE
:NOBLUE
.new_text
For blue light the maximum deviation angle is about 41.1 degrees, smaller again than
for the green light.
.select_object INCIDENT
.blue
.fast_click X 93.2
.fast_click X 92.8
.unselect_all
.pause
.goto AFTERBLUE
:DOBLUE
.new_text
Drag the mouse now to find the maximum angle for blue light.
.select_object INCIDENT
.blue
.fast_move X 93.2
.fast_click X 93.2
.shift_key 1
.mouse_limits 150 50 150 120
.allow_drag
.shift_key 0
.click 150 92.8
.new_text
The maximum angle for blue light is about 41.1 degrees as shown now.
.pause
:AFTERBLUE
.new_text
You should have noticed that the maximum angle of deviation occurs only for a
narrow range of heights of the incident ray.


Click on continue to see what happens to a group of rays striking the drop
in this range.
.pause
.new_text
Please be patient this will take a few moments.
.clear_annotations
.clear_protractors
.clear_rays
.painting 0
.recalc 0
.source_ray_count 20
.red
.plane_source
.fast_click 200 96.7
.fast_click 150 96.7
.fast_click 150 90.7
.green
.plane_source
.fast_click 200 96.2
.fast_click 150 96.2
.fast_click 150 89.2
.blue
.plane_source
.fast_click 200 95.8
.fast_click 150 95.8
.fast_click 150 89.8
.painting 1
.recalc 1
.select_extended
.fast_click -6 97
.fast_click 6 55
.painting 0
.recalc 0
.reflect 1
.refract 0
.unselect_all
.red_rays 0
.green_rays 0
.all_rays
.set_length 150
.blue_rays 0
.green_rays 1
.all_rays
.set_length 200
.green_rays 0
.red_rays 1
.all_rays
.set_length 250
.green_rays 1
.blue_rays 1
.recalc 1
.painting 1
.unselect_all
.new_text
Look at the exiting rays of different colours. Because the maximum angle of deviation
for the blue rays is less than the green which is less than the red, there are
narrow bands where only the red, green and blue rays are concentrated.
.pause
.new_text
As shown here it looks like the blue light should appear on top in the rainbow. If you
look at a rainbow or remember what one looks like then you should recall that the
blue band lies on the inner or lower edge of the rainbow.
.176
.=> EYEX
.-168
.=> EYEY
.135
.=> ANGLE
.painting 0
.call eye.rsc
.annotation Observer's eye
.end_snap
.fast_click 195 -187
.fast_click_rel 20 20
.all_rays
.set_length 250
.unselect_all
.painting 1
.zoom_extents
To explain this you need to realise that an observer positioned where the eye is shown
now would only see the red rays refracted by this drop. The blue and green rays
miss the entrance pupil of the eye.
.pause
.new_text
In order for the green or blue light to enter the pupil, it must come from a drop which is lower in
the sky that this drop.
.pause
.new_text
Please wait while the script creates a couple more drops and moves some rays about.
.painting 0
.recalc 0
.select_object DROP
.copy
.fc 0 50
.paste
.fc 0 -90
.paste
.fc 0 -230
.red_rays 0
.green_rays 0
.unselect_all
.all_rays
.cut
.fc 0 50
.paste
.fc 0 -230
.blue_rays 0
.green_rays 1
.all_rays
.cut
.fc 0 50
.paste
.fc 0 -90
.red_rays 1
.blue_rays 1
.recalc 1
.all_rays
.set_length 2500
.unselect_all
.select_object EYE
.move
.fast_click EYEX EYEY
.fast_click 1930 -1812
.scale 15
.click 1930 -1812
.unselect_all
.painting 1
.zoom_extents
.new_text
The rainbow observed by the eye is formed not by a single drop but by many
drops spread out in the sky. The blue light is observed to come from lower in
the sky than the red and thus the rainbow is formed.

The angular diameter of each coloured band in the rainbow is given by the
maximum deviation angle of the rays discussed earlier.
.pause
.new_text
That's the end of the explanation of the simple rainbow. There is also a second
order rainbow which you may have observed. Would you like to see an explanation
of how this is formed and why the coloured bands of the second rainbow are reversed?
.yes_no SKIP
.script rainbow2.rsc
:SKIP
.enable_undo 1
.quiet_snap 0
.return
