!english
.debug 0
% Demonstrate perpendicular snaps. To be run from snaps.rsc - not stand alone
.new_text
A perpendicular snap is defined in relation to some reference point and
some linear object such as a ray, linear segment of an element or tape measure.
The "perpendicular" snap point is the point on the linear object such that
a line joining it to the reference point is perpendicular to the object.
The reference point is generally the last point which was selected.
.pause
.new_text
Using a perpendiular snap make most sense when creating some object,
for example a tape measure. In this example a tape measure will be
constructed that measures the perpendicular distance between the
lower right vertex of the prism and the opposite side.
.pause
.new_text
The first end of the tape measure will be specified using an end snap.


Click on continue and this will be demonstrated to you.
.pause
.tapemeasure
.end_snap
.move -25 -1
.pause 500
.click -25 -1
.move -150 18
.new_text
Now that one end of the tape measure is defined the cursor prompts for
the second end. A perpendicular snap will be used on the opposite side
of the triangle.
.pause
.new_text
When the perpendicular snap is in effect the cursor changes to a
small box and the word Perp'r.


The cursor is positioned over the object of interest and the primary
mouse button is clicked.
.pause
.perp_snap
.move -120 13
.pause 500
.ck -120 13
.new_text
The tape measure has now been created and as you can see it is perpendicular
to the side of the prism.
.pause
.new_text
The rest of this script will coach you through using a perpendicular
snap as just described.


Do you want to continue?
.yes_no PERPLOOP PERPEND
:PERPLOOP
.clear_tapemeasures
.new_text
Click on continue then move the cursor into the main Raytrace window
and select some point for one end of the tape measure.


If you like, you can use any of the other snap types to select this
point by clicking on the secondary mouse button - do not use a
perpendicular snap, it will function but you will end up with
some unexpected results if you use perpendicular snaps for both ends
of a tapemeasure.
.pause
.tapemeasure
.user_click
:END2
.new_text
The perpendicular snap has been chosen for you, use this now to define
the second end of the tape measure by clicking on one of the linear
objects in the ray diagram.
.perp_snap
.user_click
.if== -1 PERPFAIL
.=> TAPE
.new_text
Do you want to try this again?
.yes_no PERPLOOP PERPEND
:PERPEND
.unselect_all
.clear_tapemeasures
.return
:PERPFAIL
.unselect_all
.new_text
The snap failed. Perpendicular snaps only work on rays, tape measures
or linear segments of elements.


Click on continue and try again.
.pause
.goto END2
