!english
.debug 0
% This script shows how a simply mannifying glass works
.new_text
This script demonstrates how a simple lens is used as a magnifying
glass.


Do you want to proceed?
.yes_no SKIP
.file_new
.enable_undo 0
.quiet_snap 1
.grid_snap 0
.drag_handles 1
.new_text
Please wait while the ray diagram is constructed.
.painting 0
.material zinc crown
.0
.=> CENTREX
.=> CENTREY
.150
.=> HEIGHT
.200
.=> R1
.+/-
.=> R2
.call findthck.rsc
.call mklens.rsc
.link_segments
.object_coordinates LENS 1 middle
.fc X Y
.object_coordinates LENS 3 middle
.fc X Y
.annotation Lens
.object_coordinates LENS 0 end
.end_snap
.fc X Y
.fast_click_rel 30 40
.200
.=> EYEX
.0
.=> EYEY
.180
.=> ANGLE
.call eye.rsc
.select_object EYE
.scale 2
.fc 200 0
.4
.=> POLYN
.-80
.=> POLYCENX
.0
.=> POLYCENY
.20
.=> POLYRAD
.call polygon.rsc
.unselect_all
.select_object POLY
.rotate 45
.fc POLYCENX POLYCENY
.source_ray_count 2
.set_length 250
.point_source
.object_coordinates POLY 0 end
.fc X Y
.fc 0 -5
.fc 0 5
.=> SRC
.annotation Object
.intersect_snap
.object_coordinates SRC centre
.fc X Y
.fast_click_rel -30 60
.ray_of_source SRC 0
.=> RAY0
.child_by RAY0 refraction refraction
.=> RAY1
.ray_of_source SRC 1
.=> RAY2
.child_by RAY2 refraction refraction
.=> RAY3
.unselect_all
.select_object RAY1 RAY3
.trail
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.unselect_all
.select_object SRC RAY1 RAY3
.link_by_child_rays
.object_coordinates EYE 0 end
.end_snap
.click X Y
.object_coordinates EYE 1 end
.end_snap
.click X Y
.unselect_all
.painting 1
.new_text
Here you see a side view of an object, a lens and an observer's eye.


Two rays have been traced from the object to the entrance pupil of the
eye.
.pause
.new_text
To locate the apparent image position the rays entering the eye
must be back projected.
.painting 0
.select_object RAY1 RAY3
.back_project 1
.child_by RAY1 back_proj
.=> RAY4
.child_by RAY3 back_proj
.=> RAY5
.select_object RAY4 RAY5
.set_length 200
.unselect_all
.select_object RAY1 RAY3
.annotation Image
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.fast_click_rel -30 -60
.unselect_all
.painting 1


For a simple magnifier the the object point must be closer to the lens
than the focal length of the lens which is the case shown here.
You may recall that this leads to an image point on the same side
of the lens and further from the lens than the object point.
(Enlarged upright virtual image)
.pause
.new_text
If each point around the object is considered then the entire image
can be traced out.
.pause
.steps_per 4 10 10
.drag_handles 0
.select_object SRC POLY
.auto_trace 1 0
.new_text
Notice that the image is distorted. The edge of the object further from the
lens is magnified more than the edge close to the lens. Usually when using
a magnifying glass you will look at objects which are almost two dimensional
and so you see simple magnification.
Try the following with a magnifying glass with focal length of about 20cm...
.pause
.new_text
Hold one index finger about 30cm directly in front of your face and
point it at your nose so you are looking along the length of your finger.
Notice that if you move your attention between the finger tip and the base
knuckle of the finger that your eyes have to re-converge and you may
notice an adjustment of focus or re-accomodation.
.pause
.new_text
Keep you finger in the same place and now hold a magnifying glass with
your other hand so that you are looking through it at your finger, place the
lens so that your finger just touches the lens.
.pause
.new_text
Notice that the tip of your finger in contact with the lens is hardly
magnified. The base knuckle should appear much larger than normal and
you should notice that your eyes have to re-converge and re-accomodate
much more to shift focus from the tip to the knuckle which appears
much further away. Can you reconcile what you see with the ray diagram
above?
.pause
.enable_undo 1
.new_text
Now try tilting the magnifying glass.
.reset_trails
.unselect_all
.select_object LENS
.rotate 30
.fc CENTREX CENTREY
.unselect_all
.select_object SRC POLY
.auto_trace 1 0


Notice that the image seen through the lens is much more distorted on
the side of the lens that you tilt towards you. Compare what you see
with what the ray diagram shows now.
.pause
.undo
.undo
.unselect_all
.new_text
That's all for this script.


You might like to try some other variations yourself using this
ray diagram as a starting point.
.pause
.new_text 
.drag_handles 1
.enable_undo 1
.quiet_snap 0
:SKIP
.return
