!english
.debug 0
% Script introducing image formation in plane mirrors
.file_new
.zoom_reset
.clear_var
.quiet_snap 1
.grid_snap 0
.enable_undo 0
.steps_per 3 3 3
.new_text
This script gives a brief introduction into how you can locate
image positions in ray diagrams.


Do you wish to proceed?
.yes_no SKIP
.new_text
When light leaves some point on an object it spreads out in all directions.
This can be represented by many rays radiating from the point. The
rays "diverge" from the point.


For example, light rays leaving the apex of the triangular object
fan out as shown. This occurs at all points - only one point is
considered at a time for clarity.
.painting 0
.create_shape
.fast_click -150 80
.fast_click -120 60
.fast_click -160 60
.fast_click -150 80
.end_element
.=> OBJECT
.annotation Object
.mid_snap
.fast_click -140 60
.fast_click_rel -20 -20
.=> OBANN1
.source_ray_count 30
.set_length 100
.point_source
.fast_click -150 80
.fast_click -120 60
.fast_click -160 60
.=> SRC
.painting 1
.pause
.painting 0
.50
.=> EYEX
.115
.=> EYEY
.195
.=> ANGLE
.call eye.rsc
.EYE
.=> EYE1
.annotation Eye
.end_snap
.fast_click 76 122
.fast_click_rel 20 -20
.=> EYEANN1
.unselect_all
.painting 1
.new_text
If you look at the object only some of the light rays which have
left the apex will enter the pupil of your eye. The rest of the rays
have no significance to your vision so they can be ignored.
.pause
.new_text
When your eye focusses on the object it is the direction from which
these light rays come and the divergence (angle between the rays) which
tells you where the object is located.
.painting 0
.select_object SRC
.delete
.set_length 200
.source_ray_count 2
.point_source
.end_snap
.fast_click -150 80
.fast_click 50 111
.fast_click 47 118
.=> SRC
.protractor
.intersect_snap
.fast_click -91 90
.mid_snap
.fast_click 27 106
.mid_snap
.fast_click 35 116
.=> PROT1
.select_object PROT1
.protractor_options 2 leader degrees
.fast_click -140 90
.fast_click -212 117
.painting 1
.new_text
The angle between the two rays entering the limits of the pupil is
shown here as slightly more than 1 degree.
.unselect_all
.pause
:TRACE1
.new_text
If you consider different points on the object then you can see that
as the point comes closer to the eye the angle between the two rays
increases.
.pause
.drag_handles 0
.select_object SRC OBJECT
.auto_trace 1 1
:STEP1
.step
.pause 100
.more_steps? STEP1
.unselect_all
.drag_handles 1
.pause
.new_text
This change is small, only about 0.2 degrees even in this
exagerated geometry. However this change means that the lens within
your eye must change focal length to form a sharp image as you focus your
attention on points at different distances. This gives you some
depth perception even with one eye closed but it is very poor.


Do you want to see the point move around the object again?
.yes_no TRACE1 GOON1
:GOON1
.painting 0
.select_object PROT1
.delete
.52
.=> EYEX
.29
.=> EYEY
.160
.=> ANGLE
.call eye.rsc
.annotation Second eye
.end_snap
.fast_click 78 20
.fast_click_rel 20 -20
.=> EYEANN2
.point_source
.end_snap
.fast_click -150 80
.fast_click 49 25
.fast_click 52 34
.=> SRC2
.unselect_all
.ray_of_source SRC 0
.=> RAY1
.select_object RAY1
.ray_of_source SRC2 1
.=> RAY2
.select_object RAY2
.protractor
.intersect_snap
.control_key 1
.fc 10000 10000
.control_key 0
.unselect_all
.mid_snap
.fast_click 33 36
.mid_snap
.fast_click 31 109
.=> PROT1
.select_object PROT1
.protractor_options 1 leader degrees
.fc -140 89
.fc -19 76
.unselect_all
.painting 1
:TRACE2
.new_text
Human's have stereoscopic vision. When you look at an object with both
eyes, your brain interprets the angle between the light rays entering
both eyes to give information about the distance to the object.


Because the angle between rays entering different eyes is greater and
varies more with changes in distance, it is easier for your brain to
generate the depth information.
.pause
.drag_handles 0
.select_object SRC OBJECT
.auto_trace 1 1
:STEP2
.painting 0
.step
.unselect_all
.select_object SRC2
.object_coordinates RAY2 start
.fc X Y
.object_coordinates RAY1 start
.fc X Y
.painting 1
.pause 100
.more_steps? STEP2
.unselect_all
.drag_handles 1
.new_text
For large changes in distance your brain changes the convergence
of your eyes so that light rays from the same point form images at
corresponding positions on your retinas. This is how you obtain
most of your depth perception - the rest comes from your brain
automatically comparing the apparent size of objects with which
you are familiar.


Do you want to see the point moved around the object again?
.yes_no TRACE2 GOON2
:GOON2
.new_text
In most situations with ray diagrams you ignore the effects of
stereoscopic vision. Things can get complex enough at this level.
.pause
.painting 0
.unselect_all
.select_object EYE SRC2 PROT1 EYEANN2
.delete
.painting 1
.new_text
When you need to locate an image position in a ray diagram you need
to find two (or more) rays coming from the same point in the image
which will enter the eye. By finding where these intersect you can find
the apparent image position.


To be an image that you can see the rays must be diverging when
they enter the eye and the image is know as a "virtual image".
.pause
.painting 0
.new_text
A plane mirror has now been added to the ray diagram.
.create_surface
.fast_click -95 -35
.fast_click 85 -35
.end_element
.=> MIRROR
.annotation Mirror
.mid_snap
.fast_click 0 -35
.fast_click_rel 20 -20
.=> MIRRORANN


Now if the eye looks towards the mirror rather than directly at the
object light rays can enter the eye by first reflecting off the mirror.
.select_object EYE1
.rotate 40
.fast_click 50 115
.unselect_all
.select_object SRC
.select_object OBANN1
.delete
.annotation Object point
.end_snap
.fast_click -120 60
.fast_click_rel 20 20
.=> OBANN1
.painting 1
.pause
.create_ray
.end_snap
.fast_click -120 60
.fast_click -66 -35
.finished_rays
.=> RAY1
.select_object RAY1
.end_snap
.fast_click -66 -35
.new_text
Move the cursor into the Raytrace window and move the mouse to drag
the ray about. Notice the law of reflection - that the reflected ray makes the same
angle to the normal as the incident ray.


Drag the ray until you find a position where it reflects off the
mirror and enters the eye at the left hand side of the pupil. Click on
the primary mouse button near the mirror when you have done so.
.mouse_limits -80 -50 50 -27
:NOGOOD1
.user_click NOGOOD1
.unselect_all
.new_text
To find where the eye sees the image you need a second ray.
.create_ray
.end_snap
.fast_click -120 60
.fast_click -36 46
.finished_rays
.=> RAY2


Drag this so that it reflects off the mirror and enters the right side
of the eye's pupil. Click on the primary mouse button near the mirror
when you have finished.
.select_object RAY2
.end_snap
.fast_click -36 46
:NOGOOD2
.user_click NOGOOD2
.new_text
To locate the image in this case you need to project the rays which
enter the eye back to their intersection point behind the mirror.
.pause
.child_by RAY1 reflection
.select_object
.child_by RAY2 reflection
.select_object
.back_project 1
.unselect_all
.annotation Image point
.intersect_snap
.child_by RAY1 reflection back_proj
.select_object
.child_by RAY2 reflection back_proj
.select_object
.control_key 1
.fast_click -1000 -1000
.control_key 0
.fast_click_rel -20 20
.=> NOTE


Note that the image point is located the same distance below (behind)
the mirror as the object point is above (in front of) the mirror.
.red_rays 0
.tapemeasure
.end_snap
.fast_click -120 60
.perp_snap
.fast_click 13 -35
.=> TMEAS1
.red_rays 1
.unselect_all
.tapemeasure
.intersect_snap
.child_by RAY1 reflection back_proj
.select_object
.child_by RAY2 reflection back_proj
.select_object
.control_key 1
.fast_click -1000 -1000
.control_key 0
.perp_snap
.red_rays 0
.fast_click 13 -35
.red_rays 1
.=> TMEAS2
.select_object TMEAS1 TMEAS2
.tapemeasure_options 1 1 noleader distance
.unselect_all
.pause
.select_object NOTE
.delete
.painting 0
.new_text
This can be repeated for each point on the object. This is being
done for you here.


Different coloured rays are used for each vertex on the object for
clarity only.
.green
.back_project 1
.childray_fertility
.back_project 0
.create_ray
.end_snap
.fast_click -160 60
.fast_click -80.7 -35
.=> RAY3
.end_snap
.fast_click -160 60
.fast_click -77 -35
.=> RAY4
.blue
.end_snap
.fast_click -150 80
.fast_click -65 -35
.=> RAY5
.end_snap
.fast_click -150 80
.fast_click -60.5 -35
.=> RAY6
.finished_rays
.painting 1
.pause
.painting 0
.new_text
If the intersections of each pair of back projected rays are joined
up then the full image will be seen.


Notice the image is inverted. If you look at the surface of a still
pond then the reflection of the trees on the other side will appear
upside down.
.tapemeasure
.intersect_snap
.fast_click -121 -133
.intersect_snap
.fast_click -168 -139
.=> TMEAS1
.tapemeasure
.intersect_snap
.fast_click -138 -135
.intersect_snap
.fast_click -168 -139
.=> TMEAS2
.tapemeasure
.intersect_snap
.fast_click -121 -133
.intersect_snap
.fast_click -138 -135
.=> TMEAS3
.select_object TMEAS1 TMEAS2 TMEAS3
.tapemeasure_options 1 1 noleader none
.unselect_all
.painting 1
.pause
.new_text
What do you think will happen if the mirror is slightly curved?
.pause
.new_text
Would you like to run a script to look at images in a curved mirror?
.yes_no SKIP
.script imgcrva.rsc
:SKIP
.quiet_snap 0
.enable_undo 1
.clear_var
.return
