!english
.debug 0
% Script introducing image formation in curved mirrors
.file_new
.zoom_reset
.clear_var
.quiet_snap 1
.grid_snap 0
.enable_undo 0
.new_text
This script gives a brief qualitative introduction into image
formation in a curved mirror.


Do you wish to proceed?
.yes_no SKIP
.painting 0
.create_surface
.fast_click 0 0
.arcseg
.chord_tan
.fast_click 0 160
.fc -20 160
.end_element
.=> MIRROR
.annotation Mirror
.mid_snap
.fast_click 0 0
.fast_click_rel 20 20
.=> MIRRORANN
.annotation Centre
.centre_snap
.fc 0 0
.fcr -10 40
.=> CENTREANN
.normal 1
.set_length 100
.source_ray_count 2
.point_source
.fc -120 80
.fc 0 10
.fc 0 150
.=> SRC
.annotation "Object point"
.end_snap
.fc -120 80
.fcr -10 -30
.painting 1
.new_text
Here you see two rays originating from the same point and being
reflected from a curved mirror. Normals to the mirror are shown
at the points of reflection.
.pause
.painting 0
.unselect_all
.ray_of_source SRC 0
.=> SRCRAY1
.select_object SRCRAY1
.ray_of_source SRC 1
.=> SRCRAY2
.select_object SRCRAY2
.call 2rayprot.rsc
.unselect_all
.child_by SRCRAY1 reflection
.select_object
.child_by SRCRAY2 reflection
.select_object
.call 2rayprot.rsc
.unselect_all
.painting 1
.new_text
Now two protractors have been added to show the angle between the
incident rays and the reflected rays.


If the rays strike the convex side of the mirror (as shown here) then
the angle between the reflected rays is increased compared to the
angle between the incident rays. 
.pause
.painting 0
.unselect_all
.child_by SRCRAY1 reflection
.select_object
.child_by SRCRAY2 reflection
.select_object
.annotation "Image point"
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.fcr 10 -50
.unselect_all
.painting 1
.new_text
A consequence of this is that the image point found at the point of
intersection of the reflected rays is closer to the mirror than if the
mirror was flat.
.pause
.painting 0
.select_object MIRROR
.object_coordinates MIRROR 1 tangent
.fc X Y
.fc 10 160
.unselect_all
.painting 1
.new_text
If the rays strike the mirror on the concave side as shown now then the
angle between the reflected rays is reduced and the image point moves further
from the mirror.
.pause
.painting 0
.select_object MIRROR
.object_coordinates MIRROR 1 tangent
.fc X Y
.fc 50 45
.unselect_all
.painting 1
.new_text
If the mirror is made more highly curved then it is possible to
make the reflected rays converging and hence obtain an image point
on the same side of the mirror as the original object point as is shown
now.
.pause
.new_text
Click on continue then move the cursor about to change the curvature
of the mirror


Click on the primary mouse button when you have finished.
.pause
.new_text
Notice that the image can only appear on the same side as the object
when the rays strike a concave mirror.


Also notice that when the mirror is flat the object and image distances
and the angles between incident and reflected rays are the same.
.select_object MIRROR
.drag_handles 0
.object_coordinates MIRROR 1 tangent
.fast_move X Y
.fc X Y
.mouse_limits -50 40 50 160
.allow_drag
.fc X Y
.unselect_all
.drag_handles 1
.new_text
What does all this mean when you look into a curved mirror?


Click on continue to find out.
.pause
.quiet_snap 0
.enable_undo 1
.clear_var
.script imgcrvb.rsc
