!english
.debug 0
% Creates an elliptical lens to demonstrate how spherical aberration can
% be removed
.file_new
.enable_undo 0
.quiet_snap 1
.grid_snap 0
.new_text
This script demonstrates how an elliptical surface can be used to
make a lens with no spherical aberration.


Do you want to proceed?
.yes_no SKIP
.new_text
Please wait while the ray diagram is constructed.
.painting 0
.conic_options vertex_end_eccent 0.8
.refractive_index 1.5 1.5 1.5
.create_region
.fc 0 80
.conicseg
.fc -40 0
.fc -120 0
.fc 0 -80
.lineseg
.fc 150 -80
.fc 150 80
.end_element
.=> LENS
.annotation Elliptical surface
.fc -73 61
.fcr -60 30
.=> ANNELLIP
.source_ray_count 10
.plane_source
.fc -250 80
.end_snap
.fc 0 80
.end_snap
.fc 0 -80
.=> SRC
.ray_of_source SRC 0
.=> RAY
.child_by RAY refraction
.=> RAY1
.ray_of_source SRC 9
.=> RAY
.child_by RAY refraction
.=> RAY2 
.painting 1
.new_text
Here you see a refracting region with an elliptical surface
at one end. Rays parallel to the major axis of the ellipse
are refracted towards a highly aberrated focus.
.pause
.new_text
However, if the refractive index of the material is varied
it is possible to obtain a perfect focus
.pause
.drag_handles 0
.select_object LENS
.10
.=> COUNT
.1.5
.=> RRI
:LOOP
.RRI
.- 0.025
.=> RRI
.refractive_index RRI RRI RRI
.--if!=0 COUNT LOOP
.painting 0
.unselect_all
.annotation Focus
.select_object RAY1 RAY2
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.fcr 50 50
.=> ANNFOCUS
.painting 1
.new_text
Now the refractive index is equal to the reciprocal of the
eccentricity of the elliptical surface and the aberration
has been eliminated.


In this example the eccentricity of the ellipse is 0.8 and
the refractive index is now 1.25. The point at which the
rays converge is one of the focal points of the ellipse.
.pause
.new_text
In order to obtain a focus outside the refracting region a
spherical surface can be used provided its centre coincides
with the focus currently indicated.
.pause
.painting 0
.annotation Centre
.object_coordinates ANNFOCUS base
.fc X Y
.fcr 50 -50
.=> ANNCENTRE
.create_shape
.fc 0 -80
.arcseg
.centre_end
.clockwise_arc
.intersect_snap
.select_object RAY1 RAY2
.control_key 1
.fc 1e5 1e5
.control_key 0
.fc 0 80
.end_element
.=> BACKARC
.annotation Proposed spherical surface
.fc -9 64
.fcr -50 50
.=> ANNPROP
.unselect_all
.painting 1
.new_text
Such a surface is indicated now. Notice that the rays cross
the indicated spherical surface perpendicular to the surface.
Hence when this is made the refracting boundary there will be
no deviation of the refracted rays and they will still converge
on the same point. 
.pause
.painting 0
.select_object LENS
.explode
.clear_var LENS
.unselect_all
.fc 100 -80
.delete
.fc 150 0
.delete
.fc 0 80
.selected_element
.=> ELLIPSE
.select_object BACKARC
.make_surface
.join
.make_region
.refractive_index RRI RRI RRI
.unselect_all
.select_object ANNPROP
.delete
.annotation Spherical surface
.fc -9 64
.fcr -50 50
.=> ANNSPHER
.painting 1
.new_text
And now you see a completed elliptical lens with no spherical
aberration.


Is this really a useful lens?
.pause
.new_text
What happens when the rays strike the lens at an angle to the
axis?
.painting 0
.select_object ANNFOCUS
.delete
.object_coordinates ANNCENTRE base
.annotation "Focus"
.fc X Y
.fcr 50 50
.=> ANNFOCUS
.select_object ANNCENTRE
.delete
.painting 1
.object_coordinates SRC base
.X
.=> SRCBASEX
.Y
.=> SRCBASEY
.ray_of_source SRC 0
.=> RAY
.select_object RAY
.object_coordinates RAY start
.fast_move X Y
.fc X Y

Even at small angles from the axis the aberration becomes
significant as you see now. The advantage of perfect focussing
is lost and the lens design is impractical even if the cost
of shaping the elliptical surface was not a consideration.
.SRCBASEY
.+ 10
.=> Y
.move X Y
.pause
.SRCBASEY
.+ 50
.=> YUP
.SRCBASEY
.- 50
.=> YDN
.mouse_limits X YDN X YUP
.new_text
Move the mouse now to alter the angle of incidence of the source.


Click on the primary mouse button when you have finished.
.fast_move X Y
.allow_drag
.fc SRCBASEX SRCBASEY
.new_text
That's all for this script.
.pause
:SKIP
.enable_undo 1
.quiet_snap 0
.drag_handles 1
.return
